package com.qboxus.tictic.viewModels

import android.content.Context
import android.content.SharedPreferences
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.PayoutModel
import com.qboxus.tictic.repositories.WalletRepository
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import kotlinx.coroutines.launch
import org.json.JSONObject

class ShowPayoutViewModel (
    private val context: Context,
    private val walletRepository: WalletRepository
): ViewModel() {
    lateinit var sharedPreferences: SharedPreferences
    init {
        sharedPreferences= Functions.getSharedPreference(context)
    }
    val _PayoutLiveData: MutableLiveData<ApiResponce<ArrayList<PayoutModel>>> = MutableLiveData()
    val payoutLiveData: LiveData<ApiResponce<ArrayList<PayoutModel>>> get() = _PayoutLiveData

    fun showPayout(){
        viewModelScope.launch {
            val params = JSONObject()

            walletRepository.showPayout(params,_PayoutLiveData)
        }
    }
}


class ShowPayoutFactory(
    private val context: Context,
    private val walletRepository: WalletRepository
) : ViewModelProvider.Factory {
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        if (modelClass.isAssignableFrom(ShowPayoutViewModel::class.java)) {
            return ShowPayoutViewModel(context, walletRepository) as T
        }
        throw IllegalArgumentException("Unknown ViewModel class")
    }
}